# Snail server file 

# Local IP 
host "0.0.0.0" 

# Local port 
port 5000 

# Denied IP's 
deny_ip "1.1.1.1" 
deny_ip "255.255.255.255" 

# Deined regions 
deny_region "IR" 

# Deny file.
deny_file "deny.txt"

# Rate limiting. 30 is the number of requests per second. Instead of forever, you can specify the time in seconds for which access will be denied for the IP address from which suspicious traffic is detected. 
rate_limiting enabled 30 block forever

# If more than 50000 requests are sent to the server in 1 second, the server goes into sleep mode for 15 seconds and completely stops processing requests.
rate_wait enabled 50000 for 15

# 100% of you HTML will be shown as usual source code.
xss_security disabled

# Resource folders. It's recommended to use "data".
resource_dir "data" 
resource_dir "messages" 

# Reloading when .sl file changed. 
auto_reload true 

# Upload folder
upload_dir "data"

# Is file operations allowed
allow_file_ops true

# Read-protected folders
protected_dir "data2"
deny_external_file_access false

# Max file size. 
max_upload_size_mb 50

route "/" do
set name = "Snail"
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Snail | Welcome.</title>
<link rel="icon" type="image/x-icon" href="data/snail.png">
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}

:root{
--bg: #f5f5f5;
--card: #ffffff;
--accent: #d35400;
--muted: #666;
--radius: 0px;
--container-w: 1100px;
}
*{box-sizing:border-box}
body{
margin:0;
font-family: Abel, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
background:var(--bg);
color:#222;
-webkit-font-smoothing:antialiased;
-moz-osx-font-smoothing:grayscale;
line-height:1.45; font-weight: 400!important;
}

/* Wrapper */
.page{
max-width:var(--container-w);
margin:36px auto;
padding:24px;
display:flex;
flex-direction:column;
gap:24px;
}

/* Header */
header{
display:flex;
align-items:center;
justify-content:space-between;
gap:18px;
background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));
padding:18px 22px;
border-radius:var(--radius);
box-shadow:0 4px 14px rgba(0,0,0,0.06);
backdrop-filter: blur(4px);
}
.brand{
display:flex;
align-items:center;
gap:14px;
}
.logo{
width:56px;
height:56px;
display:grid;
place-items:center;
border-radius:0px;
background: transparent;
box-shadow:0 2px 8px rgba(0,0,0,0.04);
padding:8px;
}
.logo svg{width:40px;height:40px}
.brand h1{margin:0;font-size:18px;color:var(--accent); font-weight: 400;}
.brand p{font-weight: 400; margin:0;font-size:12px;color:var(--muted)}

nav a{margin-left:18px;text-decoration:none;color:#333;font-weight:500}
.nav-actions{display:flex;align-items:center}
.btn{display:inline-block;padding:8px 14px;border-radius:0px;text-decoration:none;font-weight:600}
.btn.primary{background:var(--accent);color:#fff}
.btn.ghost{background:transparent;border:1px solid rgba(0,0,0,0.06)}

/* Hero */
.hero{
display:flex;
gap:24px;
align-items:center;
background:var(--card);
padding:28px;
border-radius:var(--radius);
box-shadow:0 8px 30px rgba(0,0,0,0.04);
}
.hero .left{flex:1}
.hero h2{color:var(--accent);margin:0 0 6px 0;font-size:28px}
.hero p{margin:0 0 14px 0;color:var(--muted)}
.hero .actions{display:flex;gap:12px}

/* Code preview */
pre.code{
background:#0f1724;color:#e6eef8;padding:14px;border-radius:0px;overflow:auto;font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, monospace;font-size:13px;line-height:1.5
}

/* Grid */
.grid{
display:grid;
grid-template-columns:repeat(3,1fr);
gap:18px;
}
.card{
background:var(--card);
padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03);
transition: transform 0.2s ease, box-shadow 0.2s ease;
}
.card:hover{
transform: translateY(-2px);
box-shadow:0 10px 25px rgba(0,0,0,0.08);
}
.card h3{margin:0 0 8px 0}
.muted{color:var(--muted);font-size:14px}

/* Footer */
footer{display:flex;justify-content:space-between;gap:12px;padding:18px;border-radius:0px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));align-items:center}

/* Responsive */
@media (max-width:980px){
.grid{grid-template-columns:repeat(2,1fr)}
header{flex-direction:column;align-items:flex-start}
footer{flex-direction:column;align-items:flex-start}
}
@media (max-width:640px){
.grid{grid-template-columns:1fr}
.hero{flex-direction:column}
.brand h1{font-size:16px}
.brand p{display:none}
nav a{display:none}
.nav-actions{gap:8px}
}
h1, h2, h3, h4 {font-weight: 400!important;}
/* Utility */
.center{display:flex;align-items:center;justify-content:center}
.pill{display:inline-block;padding:6px 10px;border-radius:0px;background:#fff6f1;color:var(--accent);font-weight:700}

/* Links Blocks */
.links-grid {
display: grid;
grid-template-columns: repeat(4, 1fr);
gap: 18px;
margin-top: 20px;
}
.link-block {
background: var(--card);
padding: 20px;
border-radius: var(--radius);
border: 1px solid rgba(0,0,0,0.05);
transition: all 0.2s ease;
}
.link-block:hover {
border-color: var(--accent);
box-shadow: 0 6px 20px rgba(211, 84, 0, 0.1);
}
.link-block h4 {
margin: 0 0 12px 0;
color: var(--accent);
font-size: 16px;
}
.link-block ul {
list-style: none;
padding: 0;
margin: 0;
}
.link-block li {
margin-bottom: 8px;
}
.link-block a {
text-decoration: none;
color: #333;
font-size: 14px;
display: flex;
align-items: center;
gap: 6px;
}
.link-block a:hover {
color: var(--accent);
}
.link-icon {
color: var(--accent);
font-weight: bold;
}

/* Features */
.feature-showcase {
background: var(--card);
padding: 28px;
border-radius: var(--radius);
box-shadow: 0 8px 30px rgba(0,0,0,0.04);
}
.feature-showcase h2 {
color: var(--accent);
margin-top: 0;
margin-bottom: 20px;
font-size: 24px;
border-bottom: 2px solid #fff6f1;
padding-bottom: 10px;
}
.feature-item {
display: flex;
gap: 16px;
margin-bottom: 20px;
padding-bottom: 20px;
border-bottom: 1px solid rgba(0,0,0,0.05);
}
.feature-item:last-child {
border-bottom: none;
}
.feature-icon {
width: 40px;
height: 40px;
background: #fff6f1;
border-radius: var(--radius);
display: flex;
align-items: center;
justify-content: center;
color: var(--accent);
font-weight: bold;
flex-shrink: 0;
}
.feature-content h3 {
margin: 0 0 6px 0;
font-size: 18px;
}
.feature-content p {
margin: 0;
color: var(--muted);
font-size: 14px;
}

/* Get Started Block */
.get-started-block {
background: var(--card);
padding: 28px;
border-radius: var(--radius);
box-shadow: 0 8px 30px rgba(0,0,0,0.04);
}
.get-started-block h2 {
color: var(--accent);
margin-top: 0;
margin-bottom: 20px;
font-size: 24px;
border-bottom: 2px solid #fff6f1;
padding-bottom: 10px;
}
.example-links {
display: grid;
grid-template-columns: repeat(2, 1fr);
gap: 16px;
}
.example-link {
background: #f9f9f9;
padding: 16px;
border-left: 4px solid var(--accent);
transition: all 0.2s ease;
}
.example-link:hover {
background: #fff6f1;
transform: translateX(4px);
}
.example-link h4 {
margin: 0 0 8px 0;
color: #333;
font-size: 16px;
}
.example-link p {
margin: 0 0 12px 0;
color: var(--muted);
font-size: 14px;
}
.example-link .link-btn {
display: inline-block;
padding: 6px 12px;
background: var(--accent);
color: white;
text-decoration: none;
font-size: 14px;
border-radius: 0px;
transition: background 0.2s ease;
}
.example-link .link-btn:hover {
background: #b84300;
}
.code-snippet {
background: #0f1724;
color: #e6eef8;
padding: 12px;
font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, monospace;
font-size: 13px;
margin-bottom: 12px;
border-radius: 0px;
overflow-x: auto;
}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand">
	<div class="logo">
		<img src = "data/snail.png" style = "width: 45px;">
		</svg>
	</div>
	<div>
		<h1>Snail</h1>
		<p>A modern, expressive programming language</p>
	</div>
</div>
<nav>

</nav>
<div class="nav-actions">
Welcome!&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
</div>
</header>



<!-- Get Started Block with Example Links -->
<section class="get-started-block">
<h2>Get Started with Examples</h2>
<p style="color: var(--muted); margin-bottom: 24px;">Explore practical examples to learn Snail quickly. Each example includes complete code and explanations.</p>

<div class="example-links">
	<div class="example-link">
		<h4>Simple welcome page</h4>
		<div class="code-snippet">route "/welcome" do<br>
set name = "Snail"<br>
print do<br>
&lt;h1>Welcome to Snail&lt;/h1><br>
end<br>
end</div>
		<p>The most basic program to get welcome page in Snail.</p>
		<a href="/welcome" class="link-btn">View Example →</a>
	</div>
	
	<div class="example-link">
		<h4>File operations</h4>
		<div class="code-snippet">folder create "images"<br>folder delete "mydir"<br>file write "text.txt" content "hello world"
		<br>file read "data.txt"<br>file delete "war.inworld"</div>
		<p>Usage of file operations.</p>
		<a href="/fileops" class="link-btn">View Example →</a>
		<a href="/manager" class="link-btn">File Manager →</a>
	</div>
	
	<div class="example-link">
		<h4>Math operations</h4>
		<div class="code-snippet">function calculate() {<br>
let a = 5;<br>
let b = 3;<br>
let c = a * (b + 3);<br>
let d = Math.sqrt(16);<br>
let e = Math.sin(90 * Math.PI / 180);<br>
let f = a + b * 3 - 4 / 2;<br>
<br>
return {c, d, e, f};
}</div>
		<p>Docs about math opertions in Snale.</p>
		<a href="math" class="link-btn">View Example →</a>
	</div>
	
	<div class="example-link">
		<h4>Quick config</h4>
		<div class="code-snippet">

host &#34;0.0.0.0&#34;<br>
port &#34;5000&#34;<br>
deny_ip &#34;1.1.1.1&#34; <br>
deny_region &#34;IR&#34; <br>
deny_file &#34;deny.txt&#34;<br>
rate_limiting enabled 30 block forever<br>
resource_dir "data" <br>
auto_reload true <br>
upload_dir "data"<br>
protected_dir "data2"<br>
deny_external_file_access false<br>
max_upload_size_mb 50		<br>
allow_file_ops enabled
		
		
		</div>
		<p>Learn async/await patterns for concurrent operations.</p>
		<a href="config" class="link-btn">View Example →</a>
	</div>
</div>


</section>



<section class="feature-showcase">
<h2>Key Features</h2>

<div class="feature-item">
	<div class="feature-icon"><img style="width: 30px;" src="data/arrow.png"></div>
	<div class="feature-content">
		<h3>High Performance</h3>
		<p>The language is based on Go and is well optimized for maximum speed, even on moderately sized servers.</p>
	</div>
</div>

<div class="feature-item">
	<div class="feature-icon"><img style="width: 30px;" src="data/arrow.png">️</div>
	<div class="feature-content">
		<h3>Safety</h3>
		<p>Snail uses its own functions to work with data that is inaccessible to anyone outside the system. You can flexibly configure security settings to help prevent hacking.</p>
	</div>
</div>

<div class="feature-item">
	<div class="feature-icon"><img style="width: 30px;" src="data/arrow.png"></div>
	<div class="feature-content">
		<h3>Easy and quick to set up</h3>
		<p>Nothing extra. Everything in one place, at one time. You can edit your website's code on the go, and it will update automatically.</p>
	</div>
</div>

<div class="feature-item">
	<div class="feature-icon"><img style="width: 30px;" src="data/arrow.png"></div>
	<div class="feature-content">
		<h3>This is... something unusual.</h3>
		<p>While most programmers use Python and other languages, you can show that promoting something unusual has its place.</p>
	</div>
</div>
</section>



<footer>
<div>
	<p style="margin:0; font-size:14px; color:var(--muted)">© 2025 Snail programming language. Thanks for choosing us!</p>
</div>

</footer>
</div>
</body>
</html>

end
end


route "/welcome" do
set name = "Snail"
print do

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/x-icon" href="data/snail.png">
<title>Welcome to [[name]].</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}

body {
font-family: Abel, sans-serif;
margin: 0;
padding: 0;
background-color: #f5f5f5;
color: #333;
	display: flex;
justify-content: center;
align-items: center;
height: 100vh;
}
.container {
max-width: 1000px;
width: 400px;
margin: 50px auto;
background-color: #fff;
padding: 20px;
display: flex;
gap: 20px;
box-shadow: 0 2px 8px rgba(0,0,0,0.1);
flex-wrap: wrap;
}
.image {
flex: 0 0 0px;
}
.image img {
max-width: 120px;
height: auto;
display: block;
margin-left: 20px;
}
.content {
flex: 1;
display: flex;
flex-direction: column;
justify-content: center;
}
.content h1 {
color: #d35400;
margin: 0 0 10px 0;
font-size: 22px;
font-weight: 500;
margin-top: 20px;
}
.content p {
line-height: 1;
margin-top: -10px;
}
@media (max-width: 600px) {
.container {
flex-direction: column;
align-items: center;
text-align: center;
}
.content {
align-items: center;
}
}
</style>
</head>
<body>
<div class="container">
<div class="image">
<img src="data/snail.png">
</div>
<div class="content">
<h1>Welcome to Snail.</h1>
<p>It is a powerful language for website development.</p>
</div>
</div>
</body>
</html>
end
end

route "/calc" do
set a = 10
set b = 2
set c = $a * ($b + 3)
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/x-icon" href="data/snail.png">
<title>Welcome to Snail.</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}

body {
font-family: Abel, sans-serif;
margin: 0;
padding: 0;
background-color: #f5f5f5;
color: #333;
	display: flex;
justify-content: center;
align-items: center;
height: 100vh;
}
.container {
max-width: 1000px;
width: 400px;
margin: 50px auto;
background-color: #fff;
padding: 20px;
display: flex;
gap: 20px;
box-shadow: 0 2px 8px rgba(0,0,0,0.1);
flex-wrap: wrap;
}
.image {
flex: 0 0 0px;
}
.image img {
max-width: 120px;
height: auto;
display: block;
margin-left: 20px;
}
.content {
flex: 1;
display: flex;
flex-direction: column;
justify-content: center;
}
.content h1 {
color: #d35400;
margin: 0 0 10px 0;
font-size: 22px;
font-weight: 500;
margin-top: 20px;
}
.content p {
line-height: 1;
margin-top: -10px;
}
@media (max-width: 600px) {
.container {
flex-direction: column;
align-items: center;
text-align: center;
}
.content {
align-items: center;
}
}
</style>
</head>
<body>
<div class="container">
<div class="image">
<img src="data/snail.png">
</div>
<div class="content">
<h1>Mathematic operation.</h1>
<p>[[c]]</p>
</div>
</div>
</body>
</html>
end
end
route "/test" do
print "<script>alert('xss test')</script>"
print "Another math: 20 * 3 = $mul"
set mul = 25 * 3
end
route "/uploads" do
set uploaded_name = ""
upload file to "res/$file"
list_dir "res" as files
set files_list_html = "<p>Uploaded. <a href='/'>Back</a></p>"
print do
	<form action="/upload" method="post" enctype="multipart/form-data">
<input type="file" name="file"/>
<input type="submit" value="Upload"/>
</form>
end
end
route "/files" do
print do

end

# Folders operations

# folder create "data/mydir"
# folder delete "mydir"
# folder list "data"

# Files operations

# file write "text.txt" content "hello world"
# file write "text2.txt" content "hello world"
# file read "text.txt"
# file delete "text2.txt"
# file list "path"
end


route "/math" do
set a = 10
set b = 2
set c = $a * ($b + 3)
set d = sqrt(16)
set e = sin(3.14159/2)
set f = $a + $b * 3 - 4 / 2

print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Math Expressions Calculator</title>
<link rel="icon" type="image/x-icon" href="data/snail.png">
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: 400;
font-style: 400;
}
:root{
--bg: #f5f5f5;
--card: #ffffff;
--accent: #d35400;
--muted: #666;
--radius: 0px;
--container-w: 1100px;
}
*{box-sizing:border-box}
h1, h2, h3, h4 {font-weight: 400!important;}
body{
margin:0;
font-family: Abel, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
background:var(--bg);
color:#222;
-webkit-font-smoothing:antialiased;
-moz-osx-font-smoothing:grayscale;
line-height:1.45; font-weight: 400!important;
}

.page{
max-width:var(--container-w);
margin:36px auto;
padding:24px;
display:flex;
flex-direction:column;
gap:24px;
}

header{
display:flex;
align-items:center;
justify-content:space-between;
gap:18px;
background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));
padding:18px 22px;
border-radius:var(--radius);
box-shadow:0 4px 14px rgba(0,0,0,0.06);
backdrop-filter: blur(4px);
}
.brand{
display:flex;
align-items:center;
gap:14px;
}
.logo{
width:56px;
height:56px;
display:grid;
place-items:center;
border-radius:0px;
background: transparent;
box-shadow:0 2px 8px rgba(0,0,0,0.04);
padding:8px;
}
.logo svg{width:40px;height:40px}
.brand h1{margin:0;font-size:18px;color:var(--accent); font-weight: 400;}
.brand p{font-weight: 400; margin:0;font-size:12px;color:var(--muted)}

nav a{margin-left:18px;text-decoration:none;color:#333;font-weight:500}
.nav-actions{display:flex;align-items:center}
.btn{display:inline-block;padding:8px 14px;border-radius:0px;text-decoration:none;font-weight:600}
.btn.primary{background:var(--accent);color:#fff}
.btn.ghost{background:transparent;border:1px solid rgba(0,0,0,0.06)}

.hero{
display:flex;
gap:24px;
align-items:center;
background:var(--card);
padding:28px;
border-radius:var(--radius);
box-shadow:0 8px 30px rgba(0,0,0,0.04);
}
.hero .left{flex:1}
.hero h2{color:var(--accent);margin:0 0 6px 0;font-size:28px}
.hero p{margin:0 0 14px 0;color:var(--muted)}
.hero .actions{display:flex;gap:12px}

pre.code{
background:#0f1724;color:#e6eef8;padding:14px;border-radius:0px;overflow:auto;font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, monospace;font-size:13px;line-height:1.5
}

.grid{
display:grid;
grid-template-columns:repeat(3,1fr);
gap:18px;
}
.card{
background:var(--card);
padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03)
}
.card h3{margin:0 0 8px 0}
.muted{color:var(--muted);font-size:14px}

footer{display:flex;justify-content:space-between;gap:12px;padding:18px;border-radius:0px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));align-items:center}

@media (max-width:980px){
.grid{grid-template-columns:repeat(2,1fr)}
header{flex-direction:column;align-items:flex-start}
footer{flex-direction:column;align-items:flex-start}
}
@media (max-width:640px){
.grid{grid-template-columns:1fr}
.hero{flex-direction:column}
.brand h1{font-size:16px}
.brand p{display:none}
nav a{display:none}
.nav-actions{gap:8px}
}

.center{display:flex;align-items:center;justify-content:center}
.pill{display:inline-block;padding:6px 10px;border-radius:0px;background:#fff6f1;color:var(--accent);font-weight:400}

.math-section {
background: var(--card);
padding: 28px;
border-radius: var(--radius);
box-shadow: 0 8px 30px rgba(0,0,0,0.04);
}
.math-section h2 {
color: var(--accent);
margin-top: 0;
margin-bottom: 20px;
font-size: 24px;
border-bottom: 2px solid #fff6f1;
padding-bottom: 10px;
}
.math-expression {
background: #f9f9f9;
padding: 16px;
margin-bottom: 12px;
border-left: 4px solid var(--accent);
font-family: 
}
.math-expression .result-placeholder {
background: #fff6f1;
padding: 4px 8px;
margin-left: 8px;
font-weight: bold;
color: var(--accent);
}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand">
	<div class="logo">
		<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
			<path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
		</svg>
	</div>
	<div>
		<h1>Snail math docs</h1>
		<p>Evaluate mathematical expressions with precision</p>
	</div>
</div>
<nav>

</nav>
<div class="nav-actions">

</div>
</header>

<section class="hero">
<div class="left">
	<h2>Watch the source of this page in server.sl.</h2>
	<p>This page demonstrates various mathematical expressions and their evaluation. The expressions below show both the formula and the expected result placeholder.</p>
	<div class="actions">
	</div>
</div>
<div>
	<pre class="code">
function calculate() {
let a = 5;
let b = 3;
let c = a * (b + 3);
let d = Math.sqrt(16);
let e = Math.sin(90 * Math.PI / 180);
let f = a + b * 3 - 4 / 2;

return {c, d, e, f};
}</pre>
</div>
</section>

<section class="math-section">
<h2>Mathematical Expressions</h2>

<div class="math-expression">
	The result of the expression $a * ($b + 3) = <span class="result-placeholder">[[c]]</span>
</div>

<div class="math-expression">
	Square root of 16 = <span class="result-placeholder">[[d]]</span>
</div>

<div class="math-expression">
	Sine of 90 degrees = <span class="result-placeholder">[[e]]</span>
</div>

<div class="math-expression">
	Expression $a + $b * 3 - 4 / 2 = <span class="result-placeholder">[[f]]</span>
</div>
<div class="math-expression"><i style="color: var(--accent)!important;">Watch the source code of <a style="color: var(--accent)!important;" href="/random">this page</a> to learn random.<br></i>
	random_range 1 10<br>
  print "Random number: random()"<br>
  print "Random from 50 to 100: random(50, 100)"<br>
  print "Math with random: (random() * 2) + 5"
end
</div>
<h3 style="margin-top: 30px; margin-bottom: 15px; color: var(--muted);">Additional Examples:</h3>

<div class="math-expression">
	2 + 2 * 2 = <span class="result-placeholder">[[2 + 2 * 2]]</span>
</div>

<div class="math-expression">
	(2 + 2) * 2 = <span class="result-placeholder">[[(2 + 2) * 2]]</span>
</div>

<div class="math-expression">
	10 / 3 = <span class="result-placeholder">[[10 / 3]]</span>
</div>

<div class="math-expression">
	abs(-5) = <span class="result-placeholder">[[abs(-5)]]</span>
</div>
</section>

<div class="grid">
<div class="card">
	<h3>Basic Arithmetic</h3>
	<p class="muted">Addition, subtraction, multiplication, division with proper operator precedence.</p>
	<span class="pill">+ - × ÷</span>
</div>
<div class="card">
	<h3>Functions</h3>
	<p class="muted">Mathematical functions like square root, trigonometric functions, absolute value.</p>
	<span class="pill">√ sin() abs()</span>
</div>
<div class="card">
	<h3>Variables</h3>
	<p class="muted">Use variables like $a and $b in expressions for dynamic calculations.</p>
	<span class="pill">$a $b $c</span>
</div>
</div>

<footer>
<div>
	<p style="margin:0; font-size:14px; color:var(--muted)">© 2025 Snail math docs.</p>
</div>

</footer>
</div>
</body>
</html>
end
end


route "/fileops" do


print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>File operations</title>
<link rel="icon" type="image/x-icon" href="data/snail.png">
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: 400;
font-style: 400;
}
:root{
--bg: #f5f5f5;
--card: #ffffff;
--accent: #d35400;
--muted: #666;
--radius: 0px;
--container-w: 1100px;
}
*{box-sizing:border-box}
h1, h2, h3, h4 {font-weight: 400!important;}
body{
margin:0;
font-family: Abel, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
background:var(--bg);
color:#222;
-webkit-font-smoothing:antialiased;
-moz-osx-font-smoothing:grayscale;
line-height:1.45; font-weight: 400!important;
}

.page{
max-width:var(--container-w);
margin:36px auto;
padding:24px;
display:flex;
flex-direction:column;
gap:24px;
}

header{
display:flex;
align-items:center;
justify-content:space-between;
gap:18px;
background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));
padding:18px 22px;
border-radius:var(--radius);
box-shadow:0 4px 14px rgba(0,0,0,0.06);
backdrop-filter: blur(4px);
}
.brand{
display:flex;
align-items:center;
gap:14px;
}
.logo{
width:56px;
height:56px;
display:grid;
place-items:center;
border-radius:0px;
background: transparent;
box-shadow:0 2px 8px rgba(0,0,0,0.04);
padding:8px;
}
.logo svg{width:40px;height:40px}
.brand h1{margin:0;font-size:18px;color:var(--accent); font-weight: 400;}
.brand p{font-weight: 400; margin:0;font-size:12px;color:var(--muted)}

nav a{margin-left:18px;text-decoration:none;color:#333;font-weight:500}
.nav-actions{display:flex;align-items:center}
.btn{display:inline-block;padding:8px 14px;border-radius:0px;text-decoration:none;font-weight:600}
.btn.primary{background:var(--accent);color:#fff}
.btn.ghost{background:transparent;border:1px solid rgba(0,0,0,0.06)}

.hero{
display:flex;
gap:24px;
align-items:center;
background:var(--card);
padding:28px;
border-radius:var(--radius);
box-shadow:0 8px 30px rgba(0,0,0,0.04);
}
.hero .left{flex:1}
.hero h2{color:var(--accent);margin:0 0 6px 0;font-size:28px}
.hero p{margin:0 0 14px 0;color:var(--muted)}
.hero .actions{display:flex;gap:12px}

pre.code{
background:#0f1724;color:#e6eef8;padding:14px;border-radius:0px;overflow:auto;font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, monospace;font-size:13px;line-height:1.5
}

.grid{
display:grid;
grid-template-columns:repeat(3,1fr);
gap:18px;
}
.card{
background:var(--card);
padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03)
}
.card h3{margin:0 0 8px 0}
.muted{color:var(--muted);font-size:14px}

footer{display:flex;justify-content:space-between;gap:12px;padding:18px;border-radius:0px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));align-items:center}

@media (max-width:980px){
.grid{grid-template-columns:repeat(2,1fr)}
header{flex-direction:column;align-items:flex-start}
footer{flex-direction:column;align-items:flex-start}
}
@media (max-width:640px){
.grid{grid-template-columns:1fr}
.hero{flex-direction:column}
.brand h1{font-size:16px}
.brand p{display:none}
nav a{display:none}
.nav-actions{gap:8px}
}

.center{display:flex;align-items:center;justify-content:center}
.pill{display:inline-block;padding:6px 10px;border-radius:0px;background:#fff6f1;color:var(--accent);font-weight:400}

.math-section {
background: var(--card);
padding: 28px;
border-radius: var(--radius);
box-shadow: 0 8px 30px rgba(0,0,0,0.04);
}
.math-section h2 {
color: var(--accent);
margin-top: 0;
margin-bottom: 20px;
font-size: 24px;
border-bottom: 2px solid #fff6f1;
padding-bottom: 10px;
}
.math-expression {
background: #f9f9f9;
padding: 16px;
margin-bottom: 12px;
border-left: 4px solid var(--accent);
font-family: 
}
.math-expression .result-placeholder {
background: #fff6f1;
padding: 4px 8px;
margin-left: 8px;
font-weight: bold;
color: var(--accent);
}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand">
	<div class="logo">
		<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
			<path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
		</svg>
	</div>
	<div>
		<h1>Snail file operations</h1>
		<p>How to work with files with help og snail.</p>
	</div>
</div>
<nav>

</nav>
<div class="nav-actions">

</div>
</header>

<section class="hero">
<div class="left">
	<h2>Watch the source of this page in server.sl.</h2>
	<p>This page contains expressions that can be used to manage files on your server.</p>
	<div class="actions">
	</div>
</div>
<div>
	<pre class="code">
Folders operations

folder create "data/mydir"
folder delete "mydir"
folder list "data"

Files operations

file write "text.txt" content "hello world"
file write "text2.txt" content "hello world"
file read "text.txt"
file delete "text2.txt"
file list "path"</pre>
</div>
</section>

<section class="math-section">
<h2>Folders</h2>

<div class="math-expression">
	folder create "data/mydir"
</div>

<div class="math-expression">
	folder delete "mydir"
</div>

<div class="math-expression">
	folder list "data"
</div>

<div class="math-expression" style="color: #b84300;">
	<i>Important! The created folders will not be created in the server root, but in the folder you specified as the resource folder. It is strongly recommended to use the folder named "data" for this purpose.
</i>   </div>

<h3 style="margin-top: 30px; margin-bottom: 15px; color: var(--muted);">Files</h3>

<div class="math-expression">
	file write "text.txt" content "hello world"
</div>

<div class="math-expression">
	file read "text.txt"
</div>

<div class="math-expression">
	file delete "text2.txt"
</div>

<div class="math-expression">
	file list "path"
</div>
</section>


<footer>
<div>
	<p style="margin:0; font-size:14px; color:var(--muted)">© 2025 Snail files docs.</p>
</div>

</footer>
</div>
</body>
</html>
end
end

route "/config" do


print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Snail config</title>
<link rel="icon" type="image/x-icon" href="data/snail.png">
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: 400;
font-style: 400;
}
:root{
--bg: #f5f5f5;
--card: #ffffff;
--accent: #d35400;
--muted: #666;
--radius: 0px;
--container-w: 1100px;
}
*{box-sizing:border-box}
h1, h2, h3, h4 {font-weight: 400!important;}
body{
margin:0;
font-family: Abel, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
background:var(--bg);
color:#222;
-webkit-font-smoothing:antialiased;
-moz-osx-font-smoothing:grayscale;
line-height:1.45; font-weight: 400!important;
}

.page{
max-width:var(--container-w);
margin:36px auto;
padding:24px;
display:flex;
flex-direction:column;
gap:24px;
}

header{
display:flex;
align-items:center;
justify-content:space-between;
gap:18px;
background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));
padding:18px 22px;
border-radius:var(--radius);
box-shadow:0 4px 14px rgba(0,0,0,0.06);
backdrop-filter: blur(4px);
}
.brand{
display:flex;
align-items:center;
gap:14px;
}
.logo{
width:56px;
height:56px;
display:grid;
place-items:center;
border-radius:0px;
background: transparent;
box-shadow:0 2px 8px rgba(0,0,0,0.04);
padding:8px;
}
.logo svg{width:40px;height:40px}
.brand h1{margin:0;font-size:18px;color:var(--accent); font-weight: 400;}
.brand p{font-weight: 400; margin:0;font-size:12px;color:var(--muted)}

nav a{margin-left:18px;text-decoration:none;color:#333;font-weight:500}
.nav-actions{display:flex;align-items:center}
.btn{display:inline-block;padding:8px 14px;border-radius:0px;text-decoration:none;font-weight:600}
.btn.primary{background:var(--accent);color:#fff}
.btn.ghost{background:transparent;border:1px solid rgba(0,0,0,0.06)}

.hero{
display:flex;
gap:24px;
align-items:center;
background:var(--card);
padding:28px;
border-radius:var(--radius);
box-shadow:0 8px 30px rgba(0,0,0,0.04);
}
.hero .left{flex:1}
.hero h2{color:var(--accent);margin:0 0 6px 0;font-size:28px}
.hero p{margin:0 0 14px 0;color:var(--muted)}
.hero .actions{display:flex;gap:12px}

pre.code{
background:#0f1724;color:#e6eef8;padding:14px;border-radius:0px;overflow:auto;font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, monospace;font-size:13px;line-height:1.5
}

.grid{
display:grid;
grid-template-columns:repeat(3,1fr);
gap:18px;
}
.card{
background:var(--card);
padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03)
}
.card h3{margin:0 0 8px 0}
.muted{color:var(--muted);font-size:14px}

footer{display:flex;justify-content:space-between;gap:12px;padding:18px;border-radius:0px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));align-items:center}

@media (max-width:980px){
.grid{grid-template-columns:repeat(2,1fr)}
header{flex-direction:column;align-items:flex-start}
footer{flex-direction:column;align-items:flex-start}
}
@media (max-width:640px){
.grid{grid-template-columns:1fr}
.hero{flex-direction:column}
.brand h1{font-size:16px}
.brand p{display:none}
nav a{display:none}
.nav-actions{gap:8px}
}

.center{display:flex;align-items:center;justify-content:center}
.pill{display:inline-block;padding:6px 10px;border-radius:0px;background:#fff6f1;color:var(--accent);font-weight:400}

.math-section {
background: var(--card);
padding: 28px;
border-radius: var(--radius);
box-shadow: 0 8px 30px rgba(0,0,0,0.04);
}
.math-section h2 {
color: var(--accent);
margin-top: 0;
margin-bottom: 20px;
font-size: 24px;
border-bottom: 2px solid #fff6f1;
padding-bottom: 10px;
}
.math-expression {
background: #f9f9f9;
padding: 16px;
margin-bottom: 12px;
border-left: 4px solid var(--accent);
font-family: 
}
.math-expression .result-placeholder {
background: #fff6f1;
padding: 4px 8px;
margin-left: 8px;
font-weight: bold;
color: var(--accent);
}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand">
	<div class="logo">
		<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
			<path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
		</svg>
	</div>
	<div>
		<h1>Snail configuration</h1>
		<p>How to set up config for your server.</p>
	</div>
</div>
<nav>

</nav>
<div class="nav-actions">

</div>
</header>

<section class="hero">
<div class="left">
	<h2>Watch the source of this page in server.sl.</h2>
	<p>Here we will talk about setting up the Snail configuration..</p>
	<div class="actions">
	</div>
</div>
<div>
	<pre class="code">
host "0.0.0.0"
port "5000"
deny_ip "1.1.1.1"
deny_region "IR"
deny_file "deny.txt"
rate_limiting enabled 30 block forever
auto_reload true
max_upload_size_mb 50
allow_file_ops enabled </pre>
</div>
</section>



<section class="math-section">
<h2>Rules and description</h2>

<div class="math-expression">
	<i style="color: #b84300;">Local IP<br></i>
host &quot;0.0.0.0&quot; 
</div>

<div class="math-expression">
	<i style="color: #b84300;">Local port <br></i>
port [digit]
</div>

<div class="math-expression">
	<i style="color: #b84300;">Denied IP&apos;s <br></i>
deny&lowbar;ip &quot;1.1.1.1&quot; <br>
deny&lowbar;ip &quot;255.255.255.255&quot; 
</div>
  <div class="math-expression">
   <i style="color: #b84300;"> Deined regions <br></i>
deny&lowbar;region &quot;IR&quot; <br>
deny&lowbar;region &quot;RU&quot; 
</div>
  <div class="math-expression">
   <i style="color: #b84300;"> Deny external access for file.<br></i>
deny&lowbar;file &quot;deny.txt&quot;
</div>
  <div class="math-expression">
   <i style="color: #b84300;"> Rate limiting. 30 is the number of requests per second. Instead of forever, you can specify the time in seconds for which access will be denied for the IP address from which suspicious traffic is detected. 
<br></i>rate&lowbar;limiting enabled 30 block forever
</div>
  <div class="math-expression">
   <i style="color: #b84300;"> 100% of you HTML will be shown as usual source code.<br></i>
xss&lowbar;security disabled

</div>
  <div class="math-expression">
   <i style="color: #b84300;"> Resource folders. It&apos;s recommended to use &quot;data&quot;.<br></i>
resource&lowbar;dir &quot;data&quot; <br>
resource&lowbar;dir &quot;images&quot; 
</div>
  <div class="math-expression">
	<i style="color: #b84300;">Auto reloading when .sl file changed. <br></i>
auto&lowbar;reload true 

</div>
  <div class="math-expression">
   <i style="color: #b84300;"> Upload folder<br></i>
upload&lowbar;dir &quot;data&quot;
</div>
  <div class="math-expression">
	<i style="color: #b84300;">Is file operations allowed<br></i>
allow&lowbar;file&lowbar;ops true
</div>
  <div class="math-expression">
   <i style="color: #b84300;"> Read-protected folders<br></i>
protected&lowbar;dir &quot;data2&quot;<br>
deny&lowbar;external&lowbar;file&lowbar;access false

</div>
  <div class="math-expression">
   <i style="color: #b84300;"> Max file size. <br></i>
max&lowbar;upload&lowbar;size&lowbar;mb 50
</div>  
<div class="math-expression" style="color: #b84300;">
	<i>Important! The created folders will not be created in the server root, but in the folder you specified as the resource folder. It is strongly recommended to use the folder named "data" for this purpose.
</i>   </div>



<footer>
<div>
	<p style="margin:0; font-size:14px; color:var(--muted)">© 2025 Snail configuration docs.</p>
</div>

</footer>
</div>
</body>
</html>
end
end

random_range 1 10

route "/random" do
  print "Random number: random()"
  print "Random from 50 to 100: random(50, 100)"
  print "Math with random: (random() * 2) + 5"
end

route "/manager" do
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/x-icon" href="data/snail.png">
<title>File Manager</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}
:root{
--bg: #f5f5f5;
--card: #ffffff;
--accent: #d35400;
--muted: #666;
--radius: 0px;
--container-w: 1100px;
}
*{box-sizing:border-box}
body{
margin:0;
font-family: Abel, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
background:var(--bg);
color:#222;
line-height:1.45; font-weight:400!important;
}
.page{
max-width:var(--container-w);
margin:36px auto;
padding:24px;
display:flex;
flex-direction:column;
gap:24px;
}
header{
display:flex;
align-items:center;
justify-content:space-between;
gap:18px;
background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));
padding:18px 22px;
border-radius:var(--radius);
box-shadow:0 4px 14px rgba(0,0,0,0.06);
backdrop-filter: blur(4px);
}
.brand{display:flex;align-items:center;gap:14px}
.logo{width:56px;height:56px;display:grid;place-items:center;border-radius:0px;background: transparent;padding:8px}
.brand h1{margin:0;font-size:18px;color:var(--accent);font-weight:400}
.brand p{margin:0;font-size:12px;color:var(--muted);font-weight:400}
h1,h2,h3,h4{font-weight:400!important; margin: 0;}
input, textarea{
width:100%;
padding:8px 10px;
margin:6px 0;
border:1px solid #ccc;
border-radius:0px;
font-size:14px;
font-weight:400;
font-family: Abel, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
}
input[type="submit"]{
background:var(--accent);
color:#fff;
border:none;
cursor:pointer;
padding:8px 14px;
font-weight:400;
border-radius:0px;
font-family: Abel, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
}
input[type="submit"]:hover{opacity:0.9}
.card{background:var(--card);padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03);}
pre{background:#f4f4f4;padding:12px;border-radius:0px;overflow:auto;}
a{color:var(--accent);text-decoration:none;}
a:hover{text-decoration:underline;}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand">
<div class="logo"><img src="data/snail.png" style="width:45px;"></div>
<div><h1>Snail</h1><p>File Manager</p></div>
</div>
</header>

<div class="card">
<h2>1) Create / Overwrite File</h2>
<form method="post" action="/fm_write">
File (relative to upload_dir):<br><input name="write_path" value="data/example.txt"><br>
Content:<br><textarea name="write_content" rows="6"></textarea><br>
<input type="submit" value="Save File">
</form>
</div>

<div class="card">
<h2>2) View File</h2>
<form method="post" action="/fm_view">
File:<br><input name="view_path" value="data/example.txt"><br>
<input type="submit" value="View">
</form>
</div>

<div class="card">
<h2>3) Delete File or Folder</h2>
<form method="post" action="/fm_delete">
Path:<br><input name="del_path" value="data/example.txt or dir"><br>
<input type="submit" value="Delete">
</form>
</div>

<div class="card">
<h2>4) Create Folder</h2>
<form method="post" action="/fm_mkdir">
Folder (relative to upload_dir):<br><input name="mkdir_path" value="data/folder"><br>
<input type="submit" value="Create Folder">
</form>
</div>

<div class="card">
<h2>5) List Files in Directory</h2>
<form method="post" action="/fm_list">
Directory (relative to upload_dir, leave empty = root):<br><input name="list_dir" value="."><br>
<input type="submit" value="Show List">
</form>
</div>

<div class="card">
<h2>6) Edit .sl File (server.sl)</h2>
<form method="post" action="/edit_sl">
File (usually server.sl):<br><input name="sl_path" value="server.sl"><br>
New content (will overwrite file):<br><textarea name="sl_content" rows="12"></textarea><br>
<input type="submit" value="Save .sl">
</form>
</div>

<p><a href="/">Return to Home</a></p>
</div>
</body>
</html>
end
end

route "/fm_write" do
file write "$write_path" content "$write_content"
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/x-icon" href="data:image/png;base64,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">
<title>File Manager — Save File</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}
:root{--bg:#f5f5f5;--card:#ffffff;--accent:#d35400;--muted:#666;--radius:0px;--container-w:1100px;}
*{box-sizing:border-box} body{margin:0;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;background:var(--bg);color:#222;line-height:1.45;font-weight:400!important;}
.page{max-width:var(--container-w);margin:36px auto;padding:24px;display:flex;flex-direction:column;gap:24px;}
header{display:flex;align-items:center;justify-content:space-between;gap:18px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));padding:18px 22px;border-radius:var(--radius);box-shadow:0 4px 14px rgba(0,0,0,0.06);backdrop-filter: blur(4px);}
.brand{display:flex;align-items:center;gap:14px} .logo{width:56px;height:56px;display:grid;place-items:center;border-radius:0px;background:transparent;padding:8px} .brand h1{margin:0;font-size:18px;color:var(--accent);font-weight:400} .brand p{margin:0;font-size:12px;color:var(--muted);font-weight:400}
h1,h2,h3,h4{font-weight:400!important; margin:0;} input, textarea{width:100%;padding:8px 10px;margin:6px 0;border:1px solid #ccc;border-radius:0px;font-size:14px;font-weight:400;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]{background:var(--accent);color:#fff;border:none;cursor:pointer;padding:8px 14px;font-weight:400;border-radius:0px;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]:hover{opacity:0.9} .card{background:var(--card);padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03);} pre{background:#f4f4f4;padding:12px;border-radius:0px;overflow:auto;} a{color:var(--accent);text-decoration:none;} a:hover{text-decoration:underline;}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand"><div class="logo"><img src="data/snail.png" style="width:45px;"></div>
<div><h1>Snail</h1><p>File Manager</p></div></div>
</header>

<div class="card">
<h2>File saved successfully</h2>
<p>File: [[write_path]]</p>
<p><a href="/manager">Back to Manager</a></p>
</div>
</div>
</body>
</html>
end
end

route "/fm_view" do
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>File Manager — View File</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}
:root{--bg:#f5f5f5;--card:#ffffff;--accent:#d35400;--muted:#666;--radius:0px;--container-w:1100px;}
*{box-sizing:border-box} body{margin:0;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;background:var(--bg);color:#222;line-height:1.45;font-weight:400!important;}
.page{max-width:var(--container-w);margin:36px auto;padding:24px;display:flex;flex-direction:column;gap:24px;}
header{display:flex;align-items:center;justify-content:space-between;gap:18px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));padding:18px 22px;border-radius:var(--radius);box-shadow:0 4px 14px rgba(0,0,0,0.06);backdrop-filter: blur(4px);}
.brand{display:flex;align-items:center;gap:14px} .logo{width:56px;height:56px;display:grid;place-items:center;border-radius:0px;background:transparent;padding:8px} .brand h1{margin:0;font-size:18px;color:var(--accent);font-weight:400} .brand p{margin:0;font-size:12px;color:var(--muted);font-weight:400}
h1,h2,h3,h4{font-weight:400!important; margin:0;} input, textarea{width:100%;padding:8px 10px;margin:6px 0;border:1px solid #ccc;border-radius:0px;font-size:14px;font-weight:400;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]{background:var(--accent);color:#fff;border:none;cursor:pointer;padding:8px 14px;font-weight:400;border-radius:0px;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]:hover{opacity:0.9} .card{background:var(--card);padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03);} pre{background:#f4f4f4;padding:12px;border-radius:0px;overflow:auto;} a{color:var(--accent);text-decoration:none;} a:hover{text-decoration:underline;}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand"><div class="logo"><img src="data/snail.png" style="width:45px;"></div>
<div><h1>Snail</h1><p>File Manager</p></div></div>
</header>

<div class="card">
<h2>Viewing file: [[view_path]]</h2>
<pre>
end
file read "$view_path"
print do
</pre>
<p><a href="/manager">Back to Manager</a></p>
</div>
</div>
</body>
</html>
end
end

route "/fm_delete" do
file delete "$del_path"
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>File Manager — Delete</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}
:root{--bg:#f5f5f5;--card:#ffffff;--accent:#d35400;--muted:#666;--radius:0px;--container-w:1100px;}
*{box-sizing:border-box} body{margin:0;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;background:var(--bg);color:#222;line-height:1.45;font-weight:400!important;}
.page{max-width:var(--container-w);margin:36px auto;padding:24px;display:flex;flex-direction:column;gap:24px;}
header{display:flex;align-items:center;justify-content:space-between;gap:18px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));padding:18px 22px;border-radius:var(--radius);box-shadow:0 4px 14px rgba(0,0,0,0.06);backdrop-filter: blur(4px);}
.brand{display:flex;align-items:center;gap:14px} .logo{width:56px;height:56px;display:grid;place-items:center;border-radius:0px;background:transparent;padding:8px} .brand h1{margin:0;font-size:18px;color:var(--accent);font-weight:400} .brand p{margin:0;font-size:12px;color:var(--muted);font-weight:400}
h1,h2,h3,h4{font-weight:400!important; margin:0;} input, textarea{width:100%;padding:8px 10px;margin:6px 0;border:1px solid #ccc;border-radius:0px;font-size:14px;font-weight:400;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]{background:var(--accent);color:#fff;border:none;cursor:pointer;padding:8px 14px;font-weight:400;border-radius:0px;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]:hover{opacity:0.9} .card{background:var(--card);padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03);} pre{background:#f4f4f4;padding:12px;border-radius:0px;overflow:auto;} a{color:var(--accent);text-decoration:none;} a:hover{text-decoration:underline;}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand"><div class="logo"><img src="data/snail.png" style="width:45px;"></div>
<div><h1>Snail</h1><p>File Manager</p></div></div>
</header>

<div class="card">
<h2>Deleted</h2>
<p>Path: [[del_path]]</p>
<p><a href="/manager">Back to Manager</a></p>
</div>
</div>
</body>
</html>
end
end

route "/fm_mkdir" do
folder create "$mkdir_path"
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>File Manager — Create Folder</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}
:root{--bg:#f5f5f5;--card:#ffffff;--accent:#d35400;--muted:#666;--radius:0px;--container-w:1100px;}
*{box-sizing:border-box} body{margin:0;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;background:var(--bg);color:#222;line-height:1.45;font-weight:400!important;}
.page{max-width:var(--container-w);margin:36px auto;padding:24px;display:flex;flex-direction:column;gap:24px;}
header{display:flex;align-items:center;justify-content:space-between;gap:18px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));padding:18px 22px;border-radius:var(--radius);box-shadow:0 4px 14px rgba(0,0,0,0.06);backdrop-filter: blur(4px);}
.brand{display:flex;align-items:center;gap:14px} .logo{width:56px;height:56px;display:grid;place-items:center;border-radius:0px;background:transparent;padding:8px} .brand h1{margin:0;font-size:18px;color:var(--accent);font-weight:400} .brand p{margin:0;font-size:12px;color:var(--muted);font-weight:400}
h1,h2,h3,h4{font-weight:400!important; margin:0;} input, textarea{width:100%;padding:8px 10px;margin:6px 0;border:1px solid #ccc;border-radius:0px;font-size:14px;font-weight:400;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]{background:var(--accent);color:#fff;border:none;cursor:pointer;padding:8px 14px;font-weight:400;border-radius:0px;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]:hover{opacity:0.9} .card{background:var(--card);padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03);} pre{background:#f4f4f4;padding:12px;border-radius:0px;overflow:auto;} a{color:var(--accent);text-decoration:none;} a:hover{text-decoration:underline;}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand"><div class="logo"><img src="data/snail.png" style="width:45px;"></div>
<div><h1>Snail</h1><p>File Manager</p></div></div>
</header>

<div class="card">
<h2>Folder created</h2>
<p>Folder: [[mkdir_path]]</p>
<p><a href="/manager">Back to Manager</a></p>
</div>
</div>
</body>
</html>
end
end

route "/fm_list" do
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>File Manager — List Files</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}
:root{--bg:#f5f5f5;--card:#ffffff;--accent:#d35400;--muted:#666;--radius:0px;--container-w:1100px;}
*{box-sizing:border-box} body{margin:0;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;background:var(--bg);color:#222;line-height:1.45;font-weight:400!important;}
.page{max-width:var(--container-w);margin:36px auto;padding:24px;display:flex;flex-direction:column;gap:24px;}
header{display:flex;align-items:center;justify-content:space-between;gap:18px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));padding:18px 22px;border-radius:var(--radius);box-shadow:0 4px 14px rgba(0,0,0,0.06);backdrop-filter: blur(4px);}
.brand{display:flex;align-items:center;gap:14px} .logo{width:56px;height:56px;display:grid;place-items:center;border-radius:0px;background:transparent;padding:8px} .brand h1{margin:0;font-size:18px;color:var(--accent);font-weight:400} .brand p{margin:0;font-size:12px;color:var(--muted);font-weight:400}
h1,h2,h3,h4{font-weight:400!important; margin:0;} input, textarea{width:100%;padding:8px 10px;margin:6px 0;border:1px solid #ccc;border-radius:0px;font-size:14px;font-weight:400;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]{background:var(--accent);color:#fff;border:none;cursor:pointer;padding:8px 14px;font-weight:400;border-radius:0px;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]:hover{opacity:0.9} .card{background:var(--card);padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03);} pre{background:#f4f4f4;padding:12px;border-radius:0px;overflow:auto;} a{color:var(--accent);text-decoration:none;} a:hover{text-decoration:underline;}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand"><div class="logo"><img src="data/snail.png" style="width:45px;"></div>
<div><h1>Snail</h1><p>File Manager</p></div></div>
</header>

<div class="card">
<h2>File List in [[list_dir]]</h2>
<pre>
end
folder list "$list_dir"
print do
</pre>
<p><a href="/manager">Back to Manager</a></p>
</div>
</div>
</body>
</html>
end
end

route "/edit_sl" do
file write "$sl_path" content "$sl_content"
print do
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>File Manager — Edit .sl</title>
<style>
@font-face {
font-family: 'Abel';
src: url('data/abel.ttf');
font-weight: normal;
font-style: normal;
}
:root{--bg:#f5f5f5;--card:#ffffff;--accent:#d35400;--muted:#666;--radius:0px;--container-w:1100px;}
*{box-sizing:border-box} body{margin:0;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;background:var(--bg);color:#222;line-height:1.45;font-weight:400!important;}
.page{max-width:var(--container-w);margin:36px auto;padding:24px;display:flex;flex-direction:column;gap:24px;}
header{display:flex;align-items:center;justify-content:space-between;gap:18px;background:linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0.9));padding:18px 22px;border-radius:var(--radius);box-shadow:0 4px 14px rgba(0,0,0,0.06);backdrop-filter: blur(4px);}
.brand{display:flex;align-items:center;gap:14px} .logo{width:56px;height:56px;display:grid;place-items:center;border-radius:0px;background:transparent;padding:8px} .brand h1{margin:0;font-size:18px;color:var(--accent);font-weight:400} .brand p{margin:0;font-size:12px;color:var(--muted);font-weight:400}
h1,h2,h3,h4{font-weight:400!important; margin:0;} input, textarea{width:100%;padding:8px 10px;margin:6px 0;border:1px solid #ccc;border-radius:0px;font-size:14px;font-weight:400;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]{background:var(--accent);color:#fff;border:none;cursor:pointer;padding:8px 14px;font-weight:400;border-radius:0px;font-family:Abel,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;}
input[type="submit"]:hover{opacity:0.9} .card{background:var(--card);padding:18px;border-radius:0px;box-shadow:0 6px 20px rgba(0,0,0,0.03);} pre{background:#f4f4f4;padding:12px;border-radius:0px;overflow:auto;} a{color:var(--accent);text-decoration:none;} a:hover{text-decoration:underline;}
</style>
</head>
<body>
<div class="page">
<header>
<div class="brand"><div class="logo"><img src="data/snail.png" style="width:45px;"></div>
<div><h1>Snail</h1><p>File Manager</p></div></div>
</header>

<div class="card">
<h2>.sl File Saved</h2>
<p>File: [[sl_path]]</p>
<p>If auto_reload is enabled, the runtime will reload configuration.</p>
<p><a href="/manager">Back to Manager</a></p>
</div>
</div>
</body>
</html>
end
end
