# Snail server file 

# Local IP 
host "0.0.0.0" 

# Local port 
port 5000 

# Denied IP's 
deny_ip "1.1.1.1" 
deny_ip "255.255.255.255" 

# Deined regions 
deny_region "IR" 

# Deny file.
deny_file "deny.txt"

# Rate limiting. 30 is the number of requests per second. Instead of forever, you can specify the time in seconds for which access will be denied for the IP address from which suspicious traffic is detected. 
rate_limiting enabled 30 block forever

# If more than 50000 requests are sent to the server in 1 second, the server goes into sleep mode for 15 seconds and completely stops processing requests.
rate_wait enabled 50000 for 15

# 100% of you HTML will be shown as usual source code.
xss_security disabled

# Resource folders. It's recommended to use "data".
resource_dir "data" 
resource_dir "messages" 

# Reloading when .sl file changed. 
auto_reload true 

# Upload folder
upload_dir "data"

# Is file operations allowed
allow_file_ops true

# Read-protected folders
protected_dir "data2"
deny_external_file_access false

# Max file size. 
max_upload_size_mb 50

route "/" do
print do
<h1>Welcome</h1>
end
end